% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose.functions.R
\name{dloglin}
\alias{dloglin}
\title{Log-linear (exponential) dose-response function}
\usage{
dloglin()
}
\value{
An object of \code{class("dosefun")}
}
\description{
Modelled assuming relative effects (\code{"rel"})
}
\details{
\eqn{rate\times{log(x + 1)}}

Dose-response parameter arguments:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Implies that \emph{relative} effects should be pooled for this dose-response parameter separately for each agent in the network. \cr
   \code{"common"} \tab Implies that all agents share the same common effect for this dose-response parameter. \cr
   \code{"random"} \tab Implies that all agents share a similar (exchangeable) effect for this dose-response parameter. This approach allows for modelling of variability between agents. \cr
   \code{numeric()} \tab Assigned a numeric value, indicating that this dose-response parameter should not be estimated from the data but should be assigned the numeric value determined by the user. This can be useful for fixing specific dose-response parameters (e.g. Hill parameters in Emax functions) to a single value. \cr
}
}
\examples{
dloglin()

}
\references{
\insertAllCited
}
