% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose.functions.R
\name{dmulti}
\alias{dmulti}
\title{Agent-specific dose-response function}
\usage{
dmulti(funs = list())
}
\arguments{
\item{funs}{A list of objects of \code{class("dosefun")}, each element of which corresponds to
an agent in the dataset to be modelled. The list length must be equal to the number of
agents in \code{network$agents} used in \code{mbnma.run()}, and the order of the dose-response
functions in the list is assumed to correspond to the same order of agents in \code{network$agents}.}
}
\value{
An object of \code{class("dosefun")}
}
\description{
Function combines different dose-response functions together to create an object containing
parameters for multiple dose-response functions.
}
\examples{

funs <- c(rep(list(demax()),3),
          rep(list(dloglin()),2),
          rep(list(demax(ed50="common")),3),
          rep(list(dexp()),2))

dmulti(funs)
}
