% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.functions.R
\name{fitplot}
\alias{fitplot}
\title{Plot fitted values from MBNMA model}
\usage{
fitplot(
  mbnma,
  treat.labs = NULL,
  disp.obs = TRUE,
  n.iter = round(mbnma$BUGSoutput$n.iter/4),
  n.thin = mbnma$BUGSoutput$n.thin,
  ...
)
}
\arguments{
\item{mbnma}{An S3 object of class \code{"mbnma"} generated by running
a time-course MBNMA model}

\item{treat.labs}{A character vector of treatment labels with which to name graph panels.
Can use \code{mb.network()[["treatments"]]} with original dataset if in doubt.}

\item{disp.obs}{A boolean object to indicate whether raw data responses should be
plotted as points on the graph}

\item{n.iter}{number of total iterations per chain (including burn in;
    default: 2000)}

\item{n.thin}{thinning rate. Must be a positive integer.  Set
    \code{n.thin} > 1 to save memory and computation time if
    \code{n.iter} is large.  Default is \code{max(1, floor(n.chains *
    (n.iter-n.burnin) / 1000))} which will only thin if there are at
    least 2000 simulations.}

\item{...}{Arguments to be sent to \code{ggplot2::ggplot()}}
}
\value{
Generates a plot of fitted values from the MBNMA model and returns a list containing
the plot (as an object of class \code{c("gg", "ggplot")}), and a data.frame of posterior mean
fitted values for each observation.
}
\description{
Plot fitted values from MBNMA model
}
\details{
Fitted values should only be plotted for models that have converged successfully.
If fitted values (\code{theta}) have not been monitored in \code{mbnma$parameters.to.save}
then additional iterations will have to be run to get results for these.
}
\examples{
\donttest{
# Make network
painnet <- mb.network(osteopain)

# Run MBNMA
mbnma <- mb.run(painnet,
  fun=temax(pool.emax="rel", method.emax="common",
    pool.et50="abs", method.et50="random"))

# Plot fitted values from the model
# Monitor fitted values for 500 additional iterations
fitplot(mbnma, n.iter=500)
}

}
