% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.jags.R
\name{mb.write}
\alias{mb.write}
\title{Write MBNMA time-course models JAGS code}
\usage{
mb.write(
  fun = tpoly(degree = 1),
  link = "identity",
  positive.scale = TRUE,
  intercept = NULL,
  rho = 0,
  covar = "varadj",
  omega = NULL,
  corparam = TRUE,
  sdscale = FALSE,
  class.effect = list(),
  UME = FALSE
)
}
\arguments{
\item{fun}{An object of class \code{"timefun"} generated (see Details) using any of
\code{tloglin()}, \code{tpoly()}, \code{titp()}, \code{temax()}, \code{tfpoly()}, \code{tspline()} or \code{tuser()}}

\item{link}{Can take either \code{"identity"} (the default),
\code{"log"} (for modelling Ratios of Means \insertCite{friedrich2011}{MBNMAtime}) or
\code{"smd"} (for modelling Standardised Mean Differences - although this also corresponds to an identity link function).}

\item{positive.scale}{A boolean object that indicates whether all continuous
mean responses (y) are positive and therefore whether the baseline response
should be given a prior that constrains it to be positive (e.g. for scales that cannot be <0).}

\item{intercept}{A boolean object that indicates whether an intercept (written
as \code{alpha} in the model) is to be included. If left as \code{NULL} (the default), an intercept will
be included only for studies reporting absolute means, and will be excluded for
studies reporting change from baseline (as indicated in \code{network$cfb}).}

\item{rho}{The correlation coefficient when modelling within-study correlation between time points. The default is a string representing a
prior distribution in JAGS, indicating that it be estimated from the data (e.g. \code{rho="dunif(0,1)"}). \code{rho} also be assigned a
numeric value (e.g. \code{rho=0.7}), which fixes \code{rho} in the model to this value (e.g. for use in a deterministic sensitivity analysis).
If set to \code{rho=0} (the default) then this implies modelling no correlation between time points.}

\item{covar}{A character specifying the covariance structure to use for modelling within-study correlation between time-points. This can
be done by specifying one of the following:
\itemize{
\item \code{"varadj"} - a univariate likelihood with a variance adjustment to assume a constant correlation between subsequent
time points \insertCite{jansen2015}{MBNMAtime}. This is the default.
\item \code{"CS"} - a multivariate normal likelihood with a
\href{https://support.sas.com/resources/papers/proceedings/proceedings/sugi30/198-30.pdf}{compound symmetry} structure
\item \code{"AR1"} - a multivariate normal likelihood with an
\href{https://support.sas.com/resources/papers/proceedings/proceedings/sugi30/198-30.pdf}{autoregressive AR1} structure
}}

\item{omega}{DEPRECATED IN VERSION 0.2.3 ONWARDS (~uniform(-1,1) now used for correlation between parameters
rather than a Wishart prior).
A scale matrix for the inverse-Wishart prior for the covariance matrix used
to model the correlation between time-course parameters (see Details for time-course functions). \code{omega} must
be a symmetric positive definite matrix with dimensions equal to the number of time-course parameters modelled using
relative effects (\code{pool="rel"}). If left as \code{NULL} (the default) a diagonal matrix with elements equal to 1
is used.}

\item{corparam}{A boolean object that indicates whether correlation should be modeled
between relative effect time-course parameters. Default is \code{FALSE} and this is automatically set to \code{FALSE} if class effects are modeled.
Setting it to \code{TRUE} models correlation between time-course parameters. This can help identify parameters
that are estimated poorly for some treatments by allowing sharing of information between
parameters for different treatments in the network, but may also cause some shrinkage.}

\item{sdscale}{Logical object to indicate whether to write a model that specifies a reference SD
for standardising when modelling using Standardised Mean Differences. Specifying \code{sdscale=TRUE}
will therefore only modify the model if link function is set to SMD (\code{link="smd"}).}

\item{class.effect}{A list of named strings that determines which time-course
parameters to model with a class effect and what that effect should be
(\code{"common"} or \code{"random"}). For example: \code{list(emax="common", et50="random")}.}

\item{UME}{Can take either \code{TRUE} or \code{FALSE} (for an unrelated mean effects
model on all or no time-course parameters respectively) or can be a vector
of parameter name strings to model as UME. For example: \code{c("beta.1", "beta.2")}.}
}
\value{
A single long character string containing the JAGS model generated
based on the arguments passed to the function.
}
\description{
Writes JAGS code for a Bayesian time-course model for model-based network
meta-analysis (MBNMA).
}
\examples{
# Write a linear time-course MBNMA:
# random treatment effects on beta.1
# equal baselines in study arms
model <- mb.write(fun=tpoly(degree=1, pool.1="rel", method.1="random"))

# Write an emax time-course MBNMA with:
# a Hill parameter
# no intercept
model <- mb.write(fun=temax(pool.emax="rel", method.emax="common",
    pool.et50="abs", method.et50="common", pool.hill="abs", method.hill="common"),
  intercept=TRUE)

# Write a log-linear time-course MBNMA with:
# AR1 correlation between time points
model <- mb.write(fun=tloglin(),
  rho="dunif(0,1)", covar="AR1")

# Define a user-defined time-course relationship for the MBNMA JAGS model
userfun <- ~ (exp(beta.1 * time) / (beta.2 * time))
model <- mb.write(fun=tuser(fun=userfun,
    pool.1="rel", method.1="random",
    pool.2="rel", method.2="common"))

}
