% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wallyplot.R
\name{wallyplot.default}
\alias{wallyplot.default}
\alias{wallyplot.lm}
\alias{wallyplot}
\title{Plots a Wally plot}
\usage{
\method{wallyplot}{default}(x, y = x, FUN = residualplot, hide = TRUE,
  simulateFunction = rnorm, ...)

\method{wallyplot}{lm}(x, y = x, FUN = residualplot, hide = TRUE,
  simulateFunction = rnorm, ...)

wallyplot(x, y = x, FUN = residualplot, hide = TRUE,
  simulateFunction = rnorm, ...)
}
\arguments{
\item{x}{a numeric vector of x values, or an lm object.}

\item{y}{a numeric vector of y values of the same length as x or a n * 9
matrix of y values - one column for each of the nine plots to make. The
first column is the one corresponding to the results from the dataset}

\item{FUN}{a function that accepts an \code{x}, \code{y} and \code{...}
argument and produces a graphical model validation plots from the \code{x}
and \code{y} values.}

\item{hide}{logical; if \code{TRUE} (the default) then the identity of the
true residual plot is hidden until the user presses a key. If \code{FALSE}
then the true residual plot is shown in the center.}

\item{simulateFunction}{The function used to produce y values under the null
hypothesis. Defaults to rnorm}

\item{...}{Other arguments passed to the plot function \code{FUN}}
}
\description{
Produces a 3x3 grid of residual- or qq-plots plots from a lm object. One of
the nine subfigures is the true residual plot/qqplot while the remaining are
plots that fulfill the assumptions of the linear model
}
\details{
Users who look at residual plots or qqnorm plots for the first time often
feel they lack the experience to determine if the residual plot is okay or
if the model assumptions are indeed violated. One way to convey "experience"
is to plot a series of graphical model validation plots simulated under the
model assumption together with the corresponding plot from the real data and
see if the user can pinpoint one of them that looks like an odd-one-out. If
the proper plot from the real data does not stand out then the assumptions
are not likely to be violated.

The Wallyplot produces a 3x3 grid of plots from a lm object or from a set of
pairs of x and y values. One of the nine subfigures is the true plot while
the remaining are plots that fulfill the assumptions of the linear model.
After the user interactively hits a key the correct residual plot
(correponding to the provided data) is shown.

The plotting function can be set using the \code{FUN} argument which should
be a function that accepts \code{x}, \code{y} and \code{...} arguments and
plots the desired figure. When \code{y} is a single vector the same length
as \code{x} then the function \code{simulateFunction} is used to generate
the remaining y values corresponding the situations under the null.

For a description of the features of the default residual plot see the help page for \code{\link{residualplot}}.
}
\examples{

\dontrun{
data(trees)
res <- lm(Volume ~ Height + Girth, data=trees)
wallyplot(res)


# Create a grid of QQ-plot figures
# Define function to plot a qq plot with an identity line
qqnorm.wally <- function(x, y, ...) { qqnorm(y, ...) ; abline(a=0, b=1) }
wallyplot(res, FUN=qqnorm.wally, main="")

# Define function to simulate components+residuals for Girth
cprsimulate <- function(n) {rnorm(n)+trees$Girth}
# Create the cpr plotting function
cprplot <- function(x, y, ...) {plot(x, y, pch=20, ...) ;
                                 lines(lowess(x, y), lty=3)}
# Create the Wallyplot
wallyplot(trees$Girth, trees$Girth+rstudent(res), FUN=cprplot,
          simulateFunction=cprsimulate, xlab="Girth")
}

}
\references{
Ekstrom, CT (2014) \emph{Teaching 'Instant Experience' with
Graphical Model Validation Techniques}. Teaching Statistics (36), p 23-26
}
\author{
Claus Ekstrom \email{claus@rprimer.dk}
}
\keyword{iplot}
