% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariateExpansions.R
\name{idct3D}
\alias{idct3D}
\title{Calculate an inverse DCT for a 3D image}
\usage{
idct3D(scores, ind, dim)
}
\arguments{
\item{scores}{A numeric vector, containing the non-zero coefficients.}

\item{ind}{An integer vector, containing the indices of the non-zero
coefficients.}

\item{dim}{A numeric vector of length 3, giving the resulting image
dimensions.}
}
\value{
A matrix of dimensions \code{dim}, which is a linear combination of
  cosine tensor basis functions with the given coefficients.
}
\description{
This function calculates an inverse (orthonormal) discrete cosine
transformation for given coefficients in three dimensions using the C-library
\code{fftw3} (see \url{http://www.fftw.org/}). As many coefficients are
expected to be zero, the values are given in compressed format (indices and
values only of non-zero coefficients).
}
\section{Warning}{
 If the C-library \code{fftw3} is not available when the
  package \code{MFPCA} is installed, this function is disabled an will throw
  an error. For full functionality install the C-library \code{fftw3} from
  \url{http://www.fftw.org/} and reinstall \code{MFPCA}.
}

\seealso{
\code{\link{dctBasis3D}}
}
\keyword{internal}
