% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fwer.support_test.R
\name{fwer.support_test}
\alias{fwer.support_test}
\title{Copula-based multiple support test which controlls the FWER}
\usage{
fwer.support_test(sample, theta, alpha = 3, beta = 4,
  boot.reps = NULL, sigLevel = 0.05)
}
\arguments{
\item{sample}{The observed sample (a matrix whose columsn are the observations)}

\item{theta}{The hypothesized scale \code{theta=c}\eqn{(\vartheta_1^*,\cdots,\vartheta_m^*}\code{)}}

\item{alpha}{First shape parameter of the Beta margins}

\item{beta}{Second shape parameter of the Beta margins}

\item{boot.reps}{number of bootstrap repetitions for estimating the parameter \eqn{\eta} of the Gumbel copula.
If this parameter is NULL then \eqn{\eta} is estimated from Kendalls tau and no bootstrap is performed.}

\item{sigLevel}{The desired significance level}
}
\value{
list l, where\itemize{
\item{l$statistic contains the values of the test statistics,}
\item{l$critvalues are the calibrated critical values,}
\item{l$test contains the test decisions,}
\item{l$etahat is estimated parameter of the Gumbel copula}}
}
\description{
Perform a multiple support test controlling the family-wise error rate (FWER) using the procedure described in Stange, Bodnar, Dickhaus (2015).
}
\details{
The test is performed assuming an i.i.d. sample \eqn{X_1,\cdots,X_n} which has the stochastic representation
\deqn{X_{i,j}=\vartheta_j Z_j} where \eqn{Z_j} takes values in \eqn{[0,1]} and which is distributed according to a Gumbel copula with Beta margins. The test simultaneously tests the hypotheses \eqn{H_{0,j}: \vartheta_j \le \vartheta_j^*} versus the corresponding alternatives \eqn{H_{1,j}: \vartheta_j>\vartheta_j^*}.

For usage examples and figure reproduction see \code{vignette('fwer-support-test',package='MHTcop')}.

Note: If the copula is only in the domain of attraction of the Gumbel copula (but not a Gumbel copula) then it is necessary to pass the
number of boot strap repetitions \code{boot.reps} as an additional parameter since the non-bootstrapped parameter estimate would not be consistent.
}
\references{
J. Stange, T. Bodnar and T. Dickhaus (2015). Uncertainty quantification for the family-wise error rate in multivariate copula models. \emph{AStA Advances in Statistical Analysis} 99.3 (2015): 281-310.
}
