% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{class}
\name{MLZ_data-class}
\alias{MLZ_data-class}
\alias{MLZ_data}
\title{MLZ_data}
\description{
An S4 class for storing data and life history parameters for a single stock.
Method functions \code{summary} and \code{plot} are available for this class (see examples).
}
\section{Slots}{

\describe{
\item{\code{Stock}}{Name of stock.}

\item{\code{Year}}{A vector of years to be considered in the model. Missing years are permitted.}

\item{\code{Len_bins}}{A vector of midpoints of length bins for \code{Len_matrix}.}

\item{\code{Len_matrix}}{A matrix of size data. The i-th row corresponds to the i-th year in \code{MLZ_data@Year}. The j-th column indexes the j-th length in \code{MLZ_data@Len_bins}.}

\item{\code{Len_df}}{A data frame containing individual length observations. The first column should be the Year and the second column should be the length.}

\item{\code{vbLinf}}{L-infinity from the von Bertalanffy growth function.}

\item{\code{vbK}}{Parameter K from the von Bertalanffy growth function.}

\item{\code{vbt0}}{Parameter t0 from the von Bertalanffy growth function.}

\item{\code{Lc}}{Length of full selectivity.}

\item{\code{M}}{Natural mortality rate. If specified, this is also the lower limit for Z.}

\item{\code{lwb}}{Exponent \code{b} from the allometric length-weight function \eqn{W = aL^b}.}

\item{\code{MeanLength}}{Vector of mean lengths of animals larger than Lc. The i-th entry corresponds to the i-th year in \code{MLZ_data@Year}.}

\item{\code{ss}}{Vector of annual sample sizes for MeanLength. The i-th entry corresponds to the i-th year in \code{MLZ_data@Year}.}

\item{\code{CPUE}}{Vector of catch-per-unit-effort data. The i-th entry corresponds to the i-th year in \code{MLZ_data@Year}.}

\item{\code{Effort}}{Vector of effort data. The i-th entry corresponds to the i-th year in \code{MLZ_data@Year}.}

\item{\code{length.units}}{Unit of measurement for lengths, i.e. "cm" or "mm".}
}}

\examples{
data(Goosefish); Goosefish
summary(Goosefish)
plot(Goosefish)

new("MLZ_data")
}
