% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{profile_MLmulti}
\alias{profile_MLmulti}
\title{Grid search for the multispecies mean length estimator}
\usage{
profile_MLmulti(MLZ.list, ncp, model = c("SSM", "MSM1", "MSM2", "MSM3"),
  startZ1 = rep(0.5, length(MLZ.list)), parallel = ifelse(ncp > 2,
  TRUE, FALSE), min.time = 3, figure = TRUE, color = TRUE)
}
\arguments{
\item{MLZ.list}{A list containing an object of class \code{MLZ_data} for each species or stock.}

\item{ncp}{The number of change points.}

\item{model}{The name of the multispecies model for the grid search.}

\item{startZ1}{A vector of length \code{ncp+1} as the starting value of total mortality rate used in the grid search.}

\item{parallel}{Whether the grid search is performed with parallel processing.}

\item{min.time}{The minimum number of years between change points. Only used if \code{ncp > 1}.}

\item{figure}{If \code{TRUE}, creates a plot of the likelihood over the grid search. Only used
if \code{ncp = 1} or \code{2}.}

\item{color}{If \code{TRUE}, creates a color plot for the likelihood surface. Only used if
\code{ncp = 2}.}
}
\value{
A matrix of change points with the total negative log-likelihood values and values 
from the each species.
}
\description{
A grid search is performed over the time series, which can be used to identify local and global minima. A
plot of the likelihood surface is also created similar to Figure 6 of Gedamke and Hoenig (2006) or
Figure 3 of Huynh et al. (2017).
}
\examples{
\dontrun{
data(PRSnapper)
profile_MLmulti(PRSnapper, ncp = 1, model = "MSM1")
}
}
\references{
Gedamke, T. and Hoenig, J.M. 2006. Estimating mortality from mean length data in
nonequilibrium situations, with application to the assessment of goosefish.
Transactions of the American Fisheries Society 135:476-487.

Huynh, Q.C, Gedamke, T., Hoenig, J.M, and Porch C. 2017. Multispecies Extensions
to a Nonequilibrium Length-Based Mortality Estimator. Marine and Coastal Fisheries 9:68-78.
}
