% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genTile.R
\name{genTile}
\alias{genTile}
\title{Generate Global Tiling System}
\usage{
genTile(tileSize = 1, offset = 0, StartNameFrom = c(0, 0),
  extent = list(xmin = -180, xmax = 180, ymin = -90, ymax = 90))
}
\arguments{
\item{tileSize}{\code{numeric}, size of a single tile in degrees (EPSG:4326).}

\item{offset}{\code{numeric}, shifts the tiling system in upper-left 
direction.}

\item{StartNameFrom}{\code{numeric}. \code{c(Lat-Direction,Lon-Direction)} 
start number in the naming of the tiles.}

\item{extent}{\code{list}. Tile system extent information, basically the 
coverage of the data on server.}
}
\value{
A \code{matrix}.
}
\description{
This function generates a matrix with bounding box information for a 
global tiling system (based on Lat/Lon).
}
\examples{
# 1x1 degree tiling system
e1 <- genTile()  
head(e1)
  
# 10x10 degree tiling system with offset to be aligned to Geoland2 Dataset
e2 <- genTile(tileSize = 10, offset = (1/112) / 2)
head(e2)

# Tiling system for SRTMv4 data (CGIAR-CSI) 
e3 <- genTile(tileSize = 5, StartNameFrom = c(1, 1), 
              extent = list(xmin = -180, xmax = 180, ymin = -60,ymax = 60)) 
head(e3)               

}
\seealso{
\code{\link{getTile}}.
}
\author{
Matteo Mattiuzzi
}
