% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp_addindex.R
\name{MODIStsp_addindex}
\alias{MODIStsp_addindex}
\title{Add custom spectral indexes}
\usage{
MODIStsp_addindex(
  new_indexbandname = "",
  new_indexfullname = "",
  new_indexformula = "",
  new_indexnodata_out = "32767"
)
}
\arguments{
\item{new_indexbandname}{\code{character} short name (acronym) of the new
spectral index (Ignored if gui == TRUE), Default: NULL}

\item{new_indexfullname}{\code{character} extended name (acronym) of the new
spectral index (Ignored if gui == TRUE), Default: NULL}

\item{new_indexformula}{\code{character} string containing the formula of
the new spectral indexes (Ignored if gui == TRUE). Variables allowed in
the formula are the names of the bands:
b1_Red, b2_NIR, b3_Blue, b4_Green, b5_SWIR, b6_SWIR and b7_SWIR.
Default: NULL}

\item{new_indexnodata_out}{\code{character} nodata value to use for rasters
containing the new index}
}
\value{
The function is called for its side effects. On success, the
MODIStsp_indexes.json
is modified so to allow computation of the additional indexes.
}
\description{
Function used to add a user-defined Spectral Index to the
default list of computable spectral indexes. Execution without the GUI
(i.e., to add a new index from a script) is also possible (see examples).
}
\details{
\itemize{
\item The function asks the user to provide the info related to the new desired
Spectral Index, checks for correctness of provided
information (e.g., correct bandnames, computable formula, etc...).
If the index is legit, it modifies the MODIStsp_addindex.json file
so to allow computation of the additional index within MODIStsp for all
products containing the required reflectance bands.
\item To remove all custom-added spectral indexes, run MODIStsp_resetindexes()
}
}
\note{
License: GPL 3.0
}
\examples{
# Run the GUI to interactively define a new index
 \dontrun{
 MODIStsp_addindex()}

# Define the new index in non-interactive execution

\dontrun{
MODIStsp_addindex(new_indexbandname = "SSI",
  new_indexfullname = "Simple Useless Index",
  new_indexformula = "b2_NIR+b1_Red")
}
}
\seealso{
\link{MODIStsp_resetindexes}
}
\author{
Lorenzo Busetto, phD (2014-2017)

Luigi Ranghetti, phD (2015)
}
