% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updt_best.R
\name{updt_best}
\alias{updt_best}
\title{Best Neighborhood Replacement Update for MOEA/D}
\usage{
updt_best(update, X, Xt, Y, Yt, V, Vt, normYs, W, BP, constraint, aggfun, ...)
}
\arguments{
\item{update}{List containing the population update parameters. See
Section \code{Update Strategies} of the \code{\link[=moead]{moead()}} documentation for
details. \code{update} must have the following key-value pairs:
\itemize{
\item \code{update$Tr}: positive integer, neighborhood size for the update
operation
\item \code{update$nr}: positive integer, maximum number of copies of a given
candidate solution.
}}

\item{X}{Matrix of candidate solutions}

\item{Xt}{Matrix of incumbent solutions}

\item{Y}{Matrix of objective function values of \code{X}}

\item{Yt}{Matrix of objective function values of \code{Xt}}

\item{V}{List object containing information about the constraint violations
of the candidate solutions, generated by \code{\link[=evaluate_population]{evaluate_population()}}}

\item{Vt}{List object containing information about the constraint violations
of the incumbent solutions, generated by \code{\link[=evaluate_population]{evaluate_population()}}}

\item{normYs}{List generated by \code{\link[=scale_objectives]{scale_objectives()}}, containing two matrices
of scaled objective values (\code{normYs$Y} and \code{normYs$Yt}) and two vectors,
containing the current estimates of the ideal (\code{normYs$minP}) and nadir
(\code{normYs$maxP}) points. See \code{\link[=scale_objectives]{scale_objectives()}} for details.}

\item{W}{matrix of weights, generated by \code{\link[=generate_weights]{generate_weights()}}.}

\item{BP}{Neighborhood list, generated by \code{\link[=define_neighborhood]{define_neighborhood()}}.}

\item{constraint}{list containing the parameters defining the constraint
handling method. See Section \code{Constraint Handling} of the \code{\link[=moead]{moead()}}
documentation for details.}

\item{aggfun}{List containing the aggregation function parameters. See
Section \code{Scalar Aggregation Functions} of the \code{\link[=moead]{moead()}} documentation for
details.}

\item{...}{other parameters (included for compatibility with generic call)}
}
\value{
List object containing the update population matrix (\code{X}),
and its corresponding matrix of objective function values (\code{Y}) and
constraint value list (\code{V}).
}
\description{
Population update using the best neighborhood replacement method for the
MOEADr package.
}
\details{
The Best Neighborhood Replacement method consists of three steps:
\itemize{
\item For each subproblem \code{i}, the best candidate solution \code{x_j} from the
entire population is determined.
\item The neighborhood of subproblem \code{i} is replaced by the neighborhood
of subproblem j. The size of this neighborhood is given by a parameter
\code{Tr}.
\item The Restricted replacement (see \code{\link[=updt_restricted]{updt_restricted()}}) is then
applied using this new neighborhood.
}

This update routine is intended to be used internally by the main \code{\link[=moead]{moead()}}
function, and should not be called directly by the user.
}
