% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{negLL1}
\alias{negLL1}
\title{negLL1 calculate log-normal log-likelihoods with a penalty}
\usage{
negLL1(pars, funk, logobs, ...)
}
\arguments{
\item{pars}{the log-transformed parameters to be used in the funk for
calculating the log of the predicted values against which the log
observed values will be compared}

\item{funk}{the function used to calculate the log-predicted values of
whatever variable is being used (eg. cpue, catches, etc.)}

\item{logobs}{the observed values log-transformed ready for comparison
with the log-predicted values from funk and pars.}

\item{...}{required to allow funk to access its other parameters without
having to explicitly declare them in negLL}
}
\value{
the negative log-likelihood using log-normal errors.
}
\description{
negLL1 calculates log-normal negative log-likelihoods. It
    expects the input parameters to be log-transformed, so the funk used
    to calculate the log or the predicted values also needs to expect
    log-transformed parameters. In addition to estimating the negative 
    log-liklelihoods for log-normally distributed data it also places a 
    penalty on the first parameter if that parameter approaches very 
    close to zero; see the function penalty0. With SPM the first 
    parameter is the population growth rate r, which obviously 
    should never be negative. The use of penalty0 prevents this.
}
\examples{
data(abdat)  #expect an answer of -31.65035
param <- log(c(r= 0.42,K=9400,Binit=3400,sigma=0.05))
negLL1(pars=param,funk=simpspm,logobs=log(abdat[,"cpue"]),indat=abdat)
}
