% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm.r
\name{plotspmdat}
\alias{plotspmdat}
\title{plotspmdat plots the fish data containing catches and cpue}
\usage{
plotspmdat(x, ...)
}
\arguments{
\item{x}{a data set that should contain 'year', 'catch', and
'cpue'}

\item{...}{extra parameters potentially used by plotspmdat}
}
\value{
nothing, but it does generate a new plot
}
\description{
plotspmdat plots a fish data set. It plots the catch 
    and CPUE against time
}
\examples{
yrs <- 2000:2010
catches <- rnorm(length(yrs),mean=150,sd=5)
ce <- rnorm(length(yrs),mean=20,sd=1)
fish <- as.data.frame(cbind(year=yrs,catch=catches,cpue=ce))
plotspmdat(fish) 
}
