% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimplexPlot.R
\name{simplexCoords}
\alias{simplexCoords}
\title{Convert 3-d coordinates to 2-d probability simplex coordinates}
\usage{
simplexCoords(v)
}
\arguments{
\item{v}{vector of 3 non-negative numbers, not summing to 0}
}
\value{
2-d coordinates to plot normalized point in simplex
}
\description{
Convert from 3-d Cartesian coordinates to 2-d coordinates suitable for plotting in the probability simplex.
}
\details{
Applies an affine coordinate trandformation that maps the centroid (1/3,1/3,1/3) to the origin (0,0), and 
rescales so that the line segments between (1,0,0), (0,1,0), and (0,0,1) are mapped to segments of length 1.

An input vector \code{v} is first normalized so its component sum to 1 before the map is applied.
}
\examples{
     simplexCoords(c(15,65,20))

}
\seealso{
\code{\link{simplexLabels}},
         \code{\link{simplexPoint}},
         \code{\link{simplexPrepare}},
         \code{\link{simplexSegment}},
         \code{\link{simplexText}}
}
