% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Empirical_MP.R
\name{doHCR}
\alias{doHCR}
\title{Hockey Stick Harvest control rule that modifies TAC.}
\usage{
doHCR(trial_TAC, est, ref, CP = c(0, 1), CPy = c(0, 1))
}
\arguments{
\item{trial_TAC}{Postitive real number, the proposed total allowable catch before HCR modification.}

\item{est}{Positive real number on same scale as ref, the estimated stock level (e.g. mean current index level)}

\item{ref}{Positive real number on same scale as est, a reference level of stock level (e.g. index level at BMSY)}

\item{CP}{Vector of real numbers, 2 positions long (c(Lx, Ux)), the lower and upper control points of a hockey stick HCR on the xaxis (est/ref). Below Lx (est/ref < Lx) the TAC is trial_TAC x Ly. Above Ux (est/ref > Ux) the TAC is trial_TAC x Uy. Between the TAC is linearly ramped between these levels.}

\item{CPy}{Vector of real numbers, 2 positions long (c(Ly, Uy)), the lower and upper control points of a hockey stick HCR on the yaxis (fraction of trial_TAC).}
}
\value{
A real number (TAC advice but theoretically could be used for effort, size limits etc).
}
\description{
A hockey stick (2 inflection points) HCR that accepts estimated level relative to reference level and modifies a proposed TAC based on control points for the x axis (est/ref) and y axis (fraction of TAC)
}
\author{
T. Carruthers
}
