% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSmix_functions_package.R
\name{bootstrapMSmix}
\alias{bootstrapMSmix}
\alias{plot.bootMSmix}
\title{Bootstrap confidence intervals for mixtures of Mallows models with Spearman distance}
\usage{
bootstrapMSmix(
  object,
  n_boot = 50,
  type = (if (object$em_settings$n_clust == 1) "non-parametric" else "soft"),
  conf_level = 0.95,
  all = FALSE,
  n_start = 10,
  parallel = FALSE
)

\method{plot}{bootMSmix}(x, ...)
}
\arguments{
\item{object}{An object of class \code{"emMSmix"} returned by \code{\link{fitMSmix}}.}

\item{n_boot}{Number of desired bootstrap samples. Defaults to 50.}

\item{type}{Character indicating which bootstrap method must be used. Available options are: \code{"non-parametric"} or \code{"parametric"} for the \eqn{G=1} case, and \code{"soft"} or \code{"separated"} for the \eqn{G>1} case. Defaults to \code{"non-parametric"} when \code{n_clust = 1} and to \code{"soft"} when \code{n_clust > 1}. See Details.}

\item{conf_level}{Value in the interval (0,1] indicating the desired confidence level of the interval estimates. Defaults to 0.95.}

\item{all}{Logical: whether the bootstrap samples of the MLEs for all the parameters must be returned. Defaults to \code{FALSE}.}

\item{n_start}{Number of starting points for the MLE on each bootstrap sample. Defaults to 10.}

\item{parallel}{Logical: whether parallelization over multiple initializations of the EM algorithm must be used. Used when \code{rankings} contains some partial rankings. Defaults to \code{FALSE}.}

\item{x}{An object of class \code{"bootMSmix"} returned by \code{\link{bootstrapMSmix}}.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\value{
An object of class \code{"bootMSmix"}, namely a list with the following named components:
\describe{
\item{\code{itemwise_ci_rho}}{The bootstrap itemwise confidence intervals for the component-specific consensus rankings.}
\item{\code{ci_boot_theta}}{The bootstrap confidence intervals for the component-specific precisions.}
\item{\code{ci_boot_weights}}{The bootstrap confidence intervals for the mixture weights. Returned when \code{n_clust > 1} and \code{type = "soft"}, otherwise \code{NULL}.}
\item{\code{boot}}{List containing all the \code{n_boot} bootstrap parameters. Returned when \code{all = TRUE}, otherwise \code{NULL}.}
}

The \code{boot} sublist contains the following named components:
\describe{
\item{\code{rho_boot}}{List of length \code{n_clust} with the bootstrap MLEs of the consensus rankings. Each element of the list is an integer \code{n_boot} \eqn{\times}{x} \code{n_items} matrix containing, in each row, the bootstrap MLEs of the consensus ranking for a specific component.}
\item{\code{theta_boot}}{Numeric \code{n_boot}\eqn{\times}{x} \code{n_clust} matrix with the bootstrap MLEs of the component-specific precision parameters in each row.}
\item{\code{weights_boot}}{Numeric \code{n_boot}\eqn{\times}{x} \code{n_clust} matrix with the bootstrap MLEs of the mixture weights in each row. Returned when  \code{n_clust > 1} and \code{type = "soft"}, otherwise \code{NULL}.}
}

For the component-specific bootstrap consensus ranking estimates, a heatmap is returned.

For the component-specific precisions and weights (for the latter when \eqn{G > 1}), a kernel density plot is returned.
}
\description{
Return the bootstrap confidence intervals for the parameters of a mixture of Mallow models with Spearman distance fitted on partial rankings.

\code{plot} method for class \code{"bootMSmix"}.
}
\details{
When \code{n_clust = 1}, two types of bootstrap are available: 1) \code{type = "non-parametric"} (default);
\code{type = "parametric"}, where the latter supports full rankings only.

When \code{n_clust > 1}, two types of bootstrap are available: 1) \code{type = "soft"} (default), which is
the soft-separated bootstrap (Crispino et al., 2024+) and returns confidence intervals for all
the parameters of the mixture of Mallow models with Spearman distance; 2) \code{type = "separated"}, which is the separated bootstrap
(Taushanov and Berchtold, 2019) and returns bootstrap samples for the component-specific
consensus rankings and precisions.
}
\examples{

## Example 1. Compute the bootstrap 95\% confidence intervals for the Antifragility dataset.
# Let us assume no clusters.
r_antifrag <- ranks_antifragility[, 1:7]
set.seed(12345)
fit <- fitMSmix(rankings = r_antifrag, n_clust = 1, n_start = 1)
# Apply non-parametric bootstrap procedure.
set.seed(12345)
boot_np <- bootstrapMSmix(object = fit, n_boot = 200)
print(boot_np)
# Apply parametric bootstrap procedure and set all = TRUE
# to return the bootstrap MLEs of the consensus ranking.
set.seed(12345)
boot_p <- bootstrapMSmix(object = fit, n_boot = 200,
                       type = "parametric", all = TRUE)
print(boot_p)
plot(boot_p)

## Example 2. Compute the bootstrap 95\% confidence intervals for the Antifragility dataset.
# Let us assume two clusters and apply soft bootstrap.
r_antifrag <- ranks_antifragility[, 1:7]
set.seed(12345)
fit <- fitMSmix(rankings = r_antifrag, n_clust = 2, n_start = 20)
set.seed(12345)
boot_soft <- bootstrapMSmix(object = fit, n_boot = 500,
                      n_start = 20, all = TRUE)
plot(boot_soft)
# Apply separated bootstrap and compare results.
set.seed(12345)
boot_sep <- bootstrapMSmix(object = fit, n_boot = 500,
                     n_start = 20, type = "separated", all = TRUE)
plot(boot_sep)
print(boot_soft)
print(boot_sep)


}
\references{
Crispino M, Mollica C and Modugno L (2024+). MSmix: An R Package for clustering partial rankings via mixtures of Mallows Models with Spearman distance. \emph{(submitted)}

Taushanov Z and Berchtold A (2019). Bootstrap validation of the estimated parameters in mixture models used for clustering. \emph{Journal de la société française de statistique}, \bold{160}(1).

Efron B (1982). The Jackknife, the Bootstrap, and Other Resampling Plans. Philadelphia, \emph{Pa. :Society for Industrial and Applied Mathematics}.
}
