% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstats.R
\name{Get_UV_from_beta}
\alias{Get_UV_from_beta}
\title{Compute the summary statistics given the genetic effect estimates and their standard errors}
\usage{
Get_UV_from_beta(Beta, Beta.se, R)
}
\arguments{
\item{Beta}{a numeric list, each sublist containing estimation information of genetic effect estimates \eqn{\beta} for each study. In each study, a numeric \eqn{m \times K} matrix with each row as a SNP and each column as a separate trait. The number of traits and the number of SNPs in each study can be different but their names are required.}

\item{Beta.se}{a numeric list, each sublist containing the standard error of estimators information for each study. In each study, a numeric \eqn{m \times K} matrix with each row as a SNP and each column as a separate trait.}

\item{R}{a SNP correlation matrix, which should contain the correlation of all the SNPs in these studies.}
}
\value{
A list containing summary statistics for each traits, including the score summary statistics \eqn{U} and their covariance matrix \eqn{V}.
}
\description{
This function allows you to calculate the score summary statistics \eqn{U} and their covariance matrix \eqn{V} for MTAR, given the genetic effect estimates and their standard errors
}
\examples{
data("beta.example")
attach(beta.example)
obs.stat <- Get_UV_from_beta(Beta = Beta, Beta.se = Beta.se, R = R)
detach(beta.example)
}
\author{
Lan Luo
}
