% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RT.R
\name{diagnosis.RT}
\alias{diagnosis.RT}
\title{Diagnosis method for the Recognition-Taguchi (RT) method}
\usage{
\method{diagnosis}{RT}(unit_space, newdata, threshold,
  includes_transformed_newdata = FALSE)
}
\arguments{
\item{unit_space}{Object of class "RT" generated by \code{\link{RT}} or
\code{\link{generates_unit_space}}(..., method = "RT").}

\item{newdata}{Matrix with n rows (samples) and p columns (variables). The
data are used to calculate the desired distances from the
unit space. All data should be continuous values and should
not have missing values.}

\item{threshold}{Numeric specifying the threshold value to classify each
sample into positive (\code{TRUE}) or negative (\code{FALSE}).}

\item{includes_transformed_newdata}{If \code{TRUE}, then the transformed data
for \code{newdata} are included in a
return object.}
}
\value{
\code{diagnosis.RT} (via \code{\link{diagnosis}}) returns a list
          containing the following components:

 \item{distance}{Vector with length n. Distances from the unit space to each
                  sample.}
 \item{le_threshold}{Vector with length n. Logical values indicating the
                      distance of each sample is less than or equal to the
                      threhold value (\code{TRUE}) or not (\code{FALSE}).}
 \item{threshold}{Numeric value to classify the sample into positive or
                   negative.}
 \item{unit_space}{Object of class "RT" passed by \code{unit_space}.}
 \item{n}{The number of samples for \code{newdata}.}
 \item{q}{The number of variables after the data transformation. q is always
           2.}
 \item{x}{If \code{includes_transformed_newdata} is \code{TRUE}, then the
           transformed data for \code{newdata} are included.}
}
\description{
\code{diagnosis.RT} (via \code{\link{diagnosis}}) calculates the
  distance based on the unit space generated by \code{\link{RT}} or
  \code{\link{generates_unit_space}}(..., method = "RT") and classifies each
  sample into positive (\code{TRUE}) or negative (\code{FALSE}) by comparing
  the values with the set threshold value.
}
\examples{
# 40 data for versicolor in the iris dataset
iris_versicolor <- iris[61:100, -5]

unit_space_RT <- RT(unit_space_data = iris_versicolor,
                    includes_transformed_data = TRUE)

# 10 data for each kind (setosa, versicolor, virginica) in the iris dataset
iris_test <- iris[c(1:10, 51:60, 101:111), -5]

diagnosis_RT <- diagnosis(unit_space = unit_space_RT,
                          newdata = iris_test,
                          threshold = 0.2,
                          includes_transformed_newdata = TRUE)

(diagnosis_RT$distance)
(diagnosis_RT$le_threshold)

}
\references{
Taguchi, G. (2006). Objective Function and Generic Function (11).
    \emph{Journal of Quality Engineering Society, 14}(2), 5-9. (In Japanese)

  Huda, F., Kajiwara, I., Hosoya, N., & Kawamura, S. (2013). Bolt loosening
   analysis and diagnosis by non-contact laser excitation vibration tests.
   \emph{Mechanical systems and signal processing, 40}(2), 589-604.
}
\seealso{
\code{\link{general_diagnosis.MT}} and \code{\link{RT}}
}

