% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-functions.R
\name{plot_samples}
\alias{plot_samples}
\title{Display realisations from a (mixture of) GP prediction}
\usage{
plot_samples(
  pred = NULL,
  samples = NULL,
  nb_samples = 50,
  x_input = NULL,
  plot_mean = TRUE,
  alpha_samples = 0.3
)
}
\arguments{
\item{pred}{A list, typically coming from \code{\link{pred_gp}},
\code{\link{pred_magma}} or \code{\link{pred_magmaclust}} functions, using
the argument 'get_full_cov = TRUE'. Required elements: \code{pred},
\code{cov}. This argument is needed if \code{samples} is missing.}

\item{samples}{A tibble or data frame, containing the samples generated from
a GP, Magma, or MagmaClust prediction. Required columns: \code{Input},
\code{Sample}, \code{Output}.  This argument is needed if \code{pred}
is missing.}

\item{nb_samples}{A number, indicating the number of samples to be drawn from
the predictive posterior distribution. For two-dimensional graphs, only
one sample can be displayed.}

\item{x_input}{A vector of character strings, indicating which 'column'
should be displayed in the case of multidimensional inputs. If
NULL(default) the Input' column is used for the x-axis. If providing a
2-dimensional vector, the corresponding columns are used for the x-axis
and the y-axis.}

\item{plot_mean}{A logical value, indicating whether the mean prediction
should be displayed on the graph.}

\item{alpha_samples}{A number, controlling transparency of the sample curves.}
}
\value{
Graph of samples drawn from a posterior distribution of a GP,
Magma, or MagmaClust prediction.
}
\description{
Display samples drawn from the posterior of a GP, Magma or
MagmaClust prediction. According to the dimension of the inputs, the graph
may represent curves or a heatmap.
}
\examples{
TRUE
}
