% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardFUNs.R
\name{AETFUN}
\alias{AETFUN}
\title{Generates Actual EvapoTranspiration rasters}
\usage{
AETFUN(PET, prec, separator = "_")
}
\arguments{
\item{PET}{RasterStack with 12 layers. Total month Potential EvapoTranspiration rasters.}

\item{prec}{RasterStack with 12 layers. Total month precipitation rasters.}

\item{separator}{character. Character that separates variable names, and scenarios.}
}
\value{
Returns a RasterLayer with estimates of Actual EvapoTranspiration in milimiters.
}
\description{
\code{AETFUN} Applies Duncan Golicher's Bucket model to Potential EvapoTranspiration and precipitation rasters in order to get Actual Evapotranspiration estimates for an area (Golicher, 2012).
}
\examples{
\donttest{
PET <- PETFUN(df_tmax, df_tmin, df_alt)
AETFUN(PET, df_prec)
}

}
\references{
Golicher (2012) <https://duncanjg.wordpress.com/2012/11/29/building-more-informative-climate-layers-for-species-distribution-modelling/>.
}
