% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_rasters.R
\name{transform_rasters}
\alias{transform_rasters}
\title{Transform raster values using custom calls.}
\usage{
transform_rasters(raster_stack, separator = "_", ncores = 1, ...)
}
\arguments{
\item{raster_stack}{RasterStack. Stack with environmental layers.}

\item{separator}{character. Character that separates variable names, years and scenarios.}

\item{ncores}{integer. Number of cores to use in parallel processing.}

\item{...}{New rasters created.}
}
\value{
Returns a RasterStack with layers for the predictions required.
}
\description{
\code{transform_rasters} Applies custom expressions to transform the values of spatial rasters in a stack, taking into account temporal repetition of those rasters.
}
\examples{
\dontrun{
FulanusEcoRasters_present <-
  get_rasters(
    var = c('prec', 'tmax', 'tmin'),
    scenarios = 'present',
    source = "C:/Users/gabri/Dropbox/Mapinguari/global_grids_10_minutes",
    ext = FulanusDistribution[c(2,3)],
    margin = 5,
    reorder = c(1, 10, 11, 12, 2, 3, 4, 5, 6, 7, 8, 9))

# You can apply any function to subsets of rasters in the stack,
# by selecting the layers with double brackets.

transform_rasters(raster_stack = FulanusEcoRasters_present$present,
    total_1sem = sum(tmax[1:6]),
    mean_1sem = mean(tmax[1:6]),
    sd_1sem = sd(tmax[1:6]),
    total_2sem = sum(tmax[7:12]),
    mean_2sem = mean(tmax[7:12]),
    sd_2sem = sd(tmax[7:12]))
}
}
