% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkMWRsites.R
\name{checkMWRsites}
\alias{checkMWRsites}
\title{Check site metadata file}
\usage{
checkMWRsites(sitdat)
}
\arguments{
\item{sitdat}{input data frame}
}
\value{
\code{sitdat} is returned as is if no errors are found, otherwise an informative error message is returned prompting the user to make the required correction to the raw data before proceeding.
}
\description{
Check site metadata file
}
\details{
This function is used internally within \code{\link{readMWRsites}} to run several checks on the input data for completeness and conformance to WQX requirements

The following checks are made:
\itemize{
\item Column name spelling: Should be the following: Monitoring Location ID, Monitoring Location Name, Monitoring Location Latitude, Monitoring Location Longitude, Location Group
\item Columns present: All columns from the previous check should be present
\item Missing longitude or latitude: No missing entries in Monitoring Location Latitude or Monitoring Location Longitude
\item Non-numeric latitude values: Values entered in Monitoring Location Latitude must be numeric
\item Non-numeric longitude values: Values entered in Monitoring Location Longitude must be numeric
\item Positive longitude values: Values in Monitoring Location Longitude must be negative
\item Missing Location ID: No missing entries for Monitoring Location ID
}
}
\examples{
library(dplyr)

sitpth <- system.file('extdata/ExampleSites.xlsx', package = 'MassWateR')

sitdat <- readxl::read_excel(sitpth, na = c('NA', 'na', ''))
    
checkMWRsites(sitdat)
}
