% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchthem.data.R
\name{matchthem.data}
\alias{matchthem.data}
\title{Outputs Matched Imputed Datasets}
\usage{
matchthem.data(object, n = 1)
}
\arguments{
\item{object}{This argument specifies an object of the \code{mimids} class.}

\item{n}{This argument specifies the matched imputed dataset number, intended to extract its matching data. The input must be a positive integer. The default is \code{1}.}
}
\value{
This function returns a subset of the imputed dataset after matching with just the matched observations from control and treatment groups.
}
\description{
The \code{matchthem.data()} function extracts matching data from an object of the \code{mimids} class.
}
\details{
The matched datasets within the \code{mimids} class object are extracted.
}
\examples{
\donttest{
#Loading the dataset
data(osteoarthritis)

#Multiply imputing the missing values
imputed.datasets <- mice(osteoarthritis, m = 5, maxit = 10,
                         method = c("", "", "mean", "polyreg", "logreg", "logreg", "logreg"))

#Matching the multiply imputed datasets
matched.datasets <- matchthem(OSP ~ AGE + SEX + BMI + RAC + SMK, imputed.datasets,
                              approach = 'within', method = 'nearest')

#Extracting the first imputed dataset
matched.dataset.1 <- matchthem.data(matched.datasets, n = 1)
}
}
\references{
Daniel Ho, Kosuke Imai, Gary King, and Elizabeth Stuart (2007). Matching as Nonparametric Preprocessing for Reducing Model Dependence in Parametric Causal Inference. \emph{Political Analysis}, 15(3): 199-236. \url{http://gking.harvard.edu/files/abs/matchp-abs.shtml}
}
\seealso{
\code{\link[=mimids]{mimids}}
}
\author{
Farhad Pishgar
}
