% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete.R
\name{complete}
\alias{complete}
\title{Extracts Imputed Datasets}
\usage{
complete(object, n = 1, include = FALSE, mild = FALSE, all = TRUE,
  ...)
}
\arguments{
\item{object}{This argument specifies an object of the \code{mids}, \code{mimids}, or \code{wimids} class.}

\item{n}{This argument specifies the imputed dataset number, intended to extract its data, or an action. The input must be a positive integer or a keyword. The keywords include \code{"all"} (produces a \code{mild} object of the imputed datasets), \code{"long"} (produces a dataset with imputed datasets stacked vertically), and \code{"broad"} (produces a dataset with imputed datasets stacked horizontally). The default is \code{1}.}

\item{include}{This argument specifies whether the original data with the missing values should be included. The input must be a logical value. The default is \code{FALSE}.}

\item{mild}{This argument specifies whether the return value should be an object of \code{mild} class. Please note that setting \code{mild = TRUE} overrides \code{n} keywords \code{"long"}, \code{"broad"}, and \code{"repeated"}. The default is \code{FALSE}.}

\item{all}{This argument specifies whether to include observations with a zero estimated weight (only for \code{mimids} or \code{wimids} objects). The default is \code{TRUE}.}

\item{...}{Additional arguments to be passed to the function.}
}
\value{
This function returns the imputed dataset within \code{mids}, \code{mimids}, or \code{wimids} class objects.
}
\description{
\code{complete()} function extracts data from an object of the \code{mids}, \code{mimids}, or \code{wimids} class.
}
\details{
The datasets within the \code{mids}, \code{mimids}, or \code{wimids} class objects are extracted.
}
\examples{
\donttest{#Loading the dataset
data(osteoarthritis)

#Multiply imputing the missing values
imputed.datasets <- mice(osteoarthritis, m = 5, maxit = 10,
                         method = c("", "", "mean", "polyreg",
                                    "logreg", "logreg", "logreg"))

#Matching the multiply imputed datasets
matched.datasets <- matchthem(OSP ~ AGE + SEX + BMI + RAC + SMK, imputed.datasets,
                              approach = 'within', method = 'nearest')

#Extracting the first imputed dataset
matched.dataset.1 <- complete(matched.datasets, n = 1)}
}
\references{
Stef van Buuren and Karin Groothuis-Oudshoorn (2011). \code{mice}: Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of Statistical Software}, 45(3): 1-67. \url{https://www.jstatsoft.org/v45/i03/}
}
\seealso{
\code{\link[=mimids]{mimids}}

\code{\link[=wimids]{wimids}}
}
\author{
Extracted from the \pkg{mice} package written by Stef van Buuren et al. with changes
}
