% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_addSingleLocation.R
\name{table_addSingleLocation}
\alias{table_addSingleLocation}
\title{Add a single new known location record to a table}
\usage{
table_addSingleLocation(
  locationTbl = NULL,
  longitude = NULL,
  latitude = NULL,
  distanceThreshold = NULL,
  stateDataset = "NaturalEarthAdm1",
  elevationService = NULL,
  addressService = NULL,
  verbose = TRUE
)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{longitude}{Single longitude in decimal degrees E.}

\item{latitude}{Single latitude in decimal degrees N.}

\item{distanceThreshold}{Distance in meters.}

\item{stateDataset}{Name of spatial dataset to use for determining state
codes, Default: "NaturalEarthAdm1".}

\item{elevationService}{Name of the elevation service to use for determining
the elevation. Default: NULL. Accepted values: "usgs".}

\item{addressService}{Name of the address service to use for determining
the street address. Default: NULL. Accepted values: "photon".}

\item{verbose}{Logical controlling the generation of progress messages.}
}
\value{
Updated tibble of known locations.
}
\description{
Incoming \code{longitude} and \code{latitude} values are compared
against the incoming \code{locationTbl} to see if they are already within
\code{distanceThreshold} meters of an existing entry.  A new record is created for
if the location is not already found in \code{locationTbl}.
}
\examples{
\donttest{
library(MazamaLocationUtils)

# Fail gracefully if any resources are not available
try({

  # Set up standard directories and spatial data
  spatialDataDir <- tempdir() # typically "~/Data/Spatial"
  initializeMazamaSpatialUtils(spatialDataDir)

  locationTbl <- get(data("wa_monitors_500"))
  
  nrow(locationTbl)

  # Coulee City, WA
  lon <- -119.290904
  lat <- 47.611942

  locationTbl <- 
    locationTbl \%>\%
    table_addSingleLocation(lon, lat, distanceThreshold = 500)
    
  nrow(locationTbl)
  
}, silent = FALSE)
}

}
\seealso{
\link{table_addLocation}

\link{table_removeRecord}

\link{table_updateSingleRecord}
}
