% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_filter.R
\name{sts_filter}
\alias{sts_filter}
\title{General purpose data filtering for \emph{sts} time series objects}
\usage{
sts_filter(sts, ...)
}
\arguments{
\item{sts}{\emph{sts} object.}

\item{...}{Logical predicates defined in terms of the variables in
\code{sts$data}.}
}
\value{
A subset of the incoming \code{sts} time series object.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
A generalized data filter for \emph{sts} objects to
choose rows/cases where conditions are true.  Multiple conditions are
combined with \code{&} or separated by a comma. Only rows where the condition
evaluates to TRUE are kept. Rows where the condition evaluates to \code{NA}
are dropped.

If an empty \emph{sts} object is passed in, it is immediately returned,
allowing for multiple filtering steps to be piped together and only checking
for an empty \emph{sts} object at the end of the pipeline.
}
\note{
Filtering is done on values in \code{sts$data}.
}
\examples{

library(MazamaTimeSeries)

unhealthy <- sts_filter(example_sts, pm25_A > 55.5, pm25_B > 55.5)
head(unhealthy$data)

}
\seealso{
\link{sts_filterDate}

\link{sts_filterDatetime}
}
