% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MedSurvey.R
\name{med.fit.BRR}
\alias{med.fit.BRR}
\title{Estimate the mediation effects and standard errors adjusting for complex surveys with BRR}
\usage{
med.fit.BRR(
  model = NULL,
  data = NULL,
  mwgtname = NULL,
  repwgtnames = NULL,
  fayfactor = 0.5,
  estimator = c("ML"),
  test = c("satorra.bentler"),
  parallel = c("no", "parallel", "snow"),
  ncore = Sys.getenv("NUMBER_OF_PROCESSORS"),
  cl = NULL,
  ...
)
}
\arguments{
\item{model}{The model being fitted. It is written in lavaan model syntax \cite{(Rosseel, 2012)}.}

\item{data}{The raw data including the variables of interest and the survey weights. It should be a dataset or dataframe.}

\item{mwgtname}{The variable name indicating the sample main weight in the dataset. See balanced repeated replications method \cite{(Wolter, 2007)} for more information about the main weight.}

\item{repwgtnames}{The variable names indicating the set of replicate weights in the dataset. See balanced repeated replications method \cite{(Wolter, 2007)} for more information about the replicate weight.}

\item{fayfactor}{The fayfactor used in the standard error calculation by fay's method \cite{(Fay & Train, 1995; Judkins, 1990)} for balanced repeated replications. Fayfactor is a value between 0 and 1. The default is 0.5.}

\item{estimator}{The method used to estimate the model. 'ML' is the default option and the only available option for current version. It is not required.}

\item{test}{The method used to generate adjusted standard errors. 'satorra.bentler' is the default option and the only available option for current version. It is not required.}

\item{parallel}{Parallel computing (\code{"no"} or \code{"parallel"} or \code{"snow"}). It is "no" by default, which means it will not use parallel computing.
The option "parallel" is to use multiple cores in a computer for parallel computing. It is used with the number of cores (\cite{ncore}).
The option "snow" is to use clusters for parallel computing. It is used with the number of clusters (\cite{cl}).}

\item{ncore}{Number of processors used for parallel computing. By default, ncore = Sys.getenv ('NUMBER_OF_PROCESSORS').}

\item{cl}{Number of clusters. It is NULL by default. When it is NULL, the program will detect the number of clusters automatically.}

\item{...}{Extra arguments. For example, ordered=c('z1','z2') is an argument to tell 'z1' and 'z2' are ordinal variables. It is not required.}
}
\value{
The model fit results as a lavaan object with the adjusted estimates, standard errors, and model fit statistics. It is a lavaan object \cite{(Rosseel, 2012)}.
}
\description{
This function is used to estimate the mediation effects adjusted for complex surveys with balanced repeated replications (BRR) \cite{ (Mai, Ha, Soulakova, 2019)}.
}
\examples{
\dontshow{
 #Toy example for check:
R <- 20
wgtnames <- paste("repwgt", seq(0,R,by=1), sep="")
mwgtname=wgtnames[1]
repwgtnames=wgtnames[2:(R+1)]
model1 <- ' # outcome
             numcg ~ u2*1 + c*workban + b*sp_adltban
           # mediator
             sp_adltban ~ u1*1 + a*workban
           # indirect effect (a*b)
             ab := a*b
           # total effect
             total := c + (a*b)
          '
fit.BRR <- med.fit.BRR(model=model1, data=MedData, mwgtname=mwgtname,
         repwgtnames=repwgtnames, fayfactor=0.5)
lavaan::summary(fit.BRR)
}
\donttest{
R <- 160
wgtnames <- paste("repwgt", seq(0,R,by=1), sep="")
mwgtname=wgtnames[1]
repwgtnames=wgtnames[2:(R+1)]

model2 <- ' # outcome
              numcg ~ u0*1 + c*workban + b1*sp_adltban + b2*sp_kidsban
            # mediator
              sp_adltban ~ u1*1 + a1*workban
              sp_kidsban ~ u2*1 + a2*workban
            #covariance of residuals
              sp_adltban ~~ sp_kidsban
            # indirect effect (a*b)
              a1b1 := a1*b1
              a2b2 := a2*b2
            # total effect
              total := c + (a1*b1) + (a2*b2)
           '
fit.BRR <- med.fit.BRR(model=model2, data=MedData, mwgtname=mwgtname,
         repwgtnames=repwgtnames, fayfactor=0.5, parallel='parallel', ncore=2)
lavaan::summary(fit.BRR)
#
# lavaan 0.6-3 ended normally after 41 iterations
#
# Optimization method                           NLMINB
# Number of free parameters                         12
#
# Number of observations                          3922
#
# Estimator                                         ML      Robust
# Model Fit Test Statistic                       0.000       0.000
# Degrees of freedom                                 0           0
# Minimum Function Value               0.0000000000000
# Scaling correction factor                                     NA
# for the Satorra-Bentler correction
#
# Parameter Estimates:
#
#   Information                                 Expected
# Information saturated (h1) model          Structured
# Standard Errors                                  BRR
#
# Regressions:
#                    Estimate  Std.Err  z-value  P(>|z|)
# numcg ~
#    workban    (c)   -0.101    0.039   -2.572    0.010
#    sp_adltbn (b1)   -0.253    0.048   -5.270    0.000
#    sp_kidsbn (b2)   -0.361    0.051   -7.006    0.000
# sp_adltban ~
#    workban   (a1)    0.069    0.018    3.753    0.000
# sp_kidsban ~
#    workban   (a2)    0.020    0.016    1.250    0.211
#
# Covariances:
#                    Estimate  Std.Err  z-value  P(>|z|)
# .sp_adltban ~~
#    .sp_kidsban        2.784    0.195   14.300    0.000
#
# Intercepts:
#                    Estimate  Std.Err  z-value  P(>|z|)
#   .numcg     (u0)   18.485    0.566   32.668    0.000
#   .sp_adltbn (u1)    4.221    0.167   25.281    0.000
#   .sp_kidsbn (u2)    7.926    0.143   55.272    0.000
#
# Variances:
#                    Estimate  Std.Err  z-value  P(>|z|)
#   .numcg            54.283    1.716   31.628    0.000
#   .sp_adltban       11.011    0.239   46.140    0.000
#   .sp_kidsban        9.402    0.209   44.998    0.000
#
# Defined Parameters:
#                    Estimate  Std.Err  z-value  P(>|z|)
#    a1b1             -0.017    0.006   -2.905    0.004
#    a2b2             -0.007    0.006   -1.234    0.217
#    total            -0.125    0.040   -3.169    0.002
}

}
\references{
Fay, R. E., & Train, G. F. (1995). Aspects of survey and model-based postcensal estimation of income and poverty characteristics for states and counties. In Proceedings of the Section on Government Statistics, American Statistical Association, Alexandria, VA (pp. 154-159).

Judkins, D. R. (1990). Fay’s method for variance estimation.Journal of Official Statistics,6(3), 223-239.

Mai, Y., Ha, T., & Soulakova, J. N. (2019). Multimediation Method With Balanced Repeated Replications For Analysis Of Complex Surveys. Structural Equation Modeling: A Multidisciplinary Journal. DOI:10.1080/10705511.2018.1559065

Rosseel, Y. (2012). Lavaan: An R package for structural equation modeling and more. Version 0.5–12 (BETA). Journal of statistical software, 48(2), 1-36. DOI:10.18637/jss.v048.i02

Wolter, K. (2007). Introduction to variance estimation. New York, NY: Springer.
}
