% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2famskatrc.R
\name{DOfamSKATRC}
\alias{DOfamSKATRC}
\title{DofamSKATRC call back function}
\usage{
DOfamSKATRC(
  markers_arg,
  range_arg,
  envir,
  pheno = 3,
  id = NULL,
  covariates = NULL,
  sqrtweights_c = NULL,
  sqrtweights_r = NULL,
  binomialimpute = TRUE,
  acc = 1e-06,
  maf = 0.05,
  phi = c(0, 0.2, 0.5, 0.9)
)
}
\arguments{
\item{markers_arg}{a data.frame with the following 5 observations:
\describe{
\item{locus_link}{is the ordinal ranking of this marker among all loci}
\item{locus_link_fill}{is the position of corresponding genotype data in the
\emph{unified_genotype_table}}
\item{MarkerName}{is the text name of the marker}
\item{chromosome}{is the integer chromosome number}
\item{position}{is the integer base pair position of marker}
}}

\item{range_arg}{one row of a ranges_arg.  The latter is a data frame of at least three
integer columns.  The columns indicate a range:
a chromosome number, a start base pair value, and an end base pair value.}

\item{envir}{'environment' containing SQLite database and other globals especially the
phenotype_table, \code{phe}.}

\item{pheno}{is an index into the phenotypes_table to select the phenotype.  Missing phenotypes
are represented by NA.}

\item{id}{a vector of individuals to be included in the test, a subset of the family members.
If NULL is given, all members will be used.}

\item{covariates}{a matrix of covariated for the phenotype.}

\item{sqrtweights_c}{weight function for common variants, if NULL use weight set in init_famSKAT}

\item{sqrtweights_r}{weight function for rare variants, if NULL use weight set in init_famSKAT.}

\item{binomialimpute}{if TRUE, impute missing genotypes using a binomial distribution.}

\item{acc}{accuracy used in Davies approximation.}

\item{maf}{threshold used to separate rare from common variants.}

\item{phi}{a vector of ratios ratios; each indicates the contribution of rare variants.}
}
\value{
None
}
\description{
Convert the genotypesraw() allele patterns of 0x10001, 0x10002 (or 0x20001), 0x20002, 0
 to the numbers 0, 1, 2, 9 for each marker. (Reverse, the order iff allele "1" has the
 minor allele frequency.)  Ignore markers that have no variants.
 Finally, invoke \code{famSKAT_RC} with the converted genotype matrix.
 Save information about the range and the p.value calculated by \code{famSKAT_RC}
 in \emph{envir$famSKATRC_results}.
 If you want to change the argument values to this function they should be changed instead
 when calling the \code{Mega2famSKATRC} function.
}
\note{
This function accumulates output in the data frame, \emph{envir$famSKATRC_results}.  It will
 print out the lines as they are generated if \emph{envir$verbose} is TRUE.  It does not write
 the data frame to a file.  You must save the data frame.
 You also must initialize the data frame when necessary.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = init_famSKATRC(db, verbose = TRUE)
ENV$famSKATRC_results = ENV$famSKATRC_results[0, ]
Mega2famSKATRC(gs=1:1, envir=ENV, pheno=3)
# this sets one of the many arguments for DOfamSKATRC
# but basically prepares the ENV for the direct use of DOfamSKATRC (below).

\donttest{
# donttestcheck: try this below instead if there is time
 Mega2famSKATRC(genes=c("CEP104"), envir=ENV, pheno=3 )
}

# DOfamSKATRC is called within Mega2famSKATRC. init_famSKATRC and Mega2famSKATRC need to be
# called to set up the environment for famSKAT_RC to run.  BUT, you should ignore DOfamSKATRC
# and use Mega2famSKATRC instead.
#
applyFnToRanges(DOfamSKATRC, ENV$refRanges[50:60, ], ENV$refIndices, envir=ENV)
# this will use all the default argument values for DOfamSKATRC

}
\seealso{
\code{\link{init_famSKATRC}}, \code{\link{Mega2famSKATRC}}
}
