% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_plot-methods.R
\docType{methods}
\name{mr_plot}
\alias{mr_plot}
\alias{mr_plot,MRAll-method}
\alias{mr_plot,MRInput-method}
\title{Draw a scatter plot of the genetic associations and/or causal estimates}
\usage{
mr_plot(object, error = TRUE, line = "ivw", orientate = FALSE, ...)

\S4method{mr_plot}{MRInput}(object, error = TRUE, line = "ivw",
  orientate = FALSE)

\S4method{mr_plot}{MRAll}(object)
}
\arguments{
\item{object}{An \code{MRInput} object or an \code{MRAll} object.}

\item{error}{When viewing an \code{MRInput} object, one can choose whether to include error bars (default is to include).}

\item{line}{When viewing an \code{MRInput} object, one can choose whether to include the IVW estimate (\code{line = "ivw"}) or the MR-Egger estimate (\code{line = "egger"}).}

\item{orientate}{When viewing an \code{MRInput} object, one can choose whether to orientate all genetic variants so that the associations with the risk factor are all positive. This is recommended particularly when plotting the MR-Egger estimate, although the default setting is \code{FALSE}.}

\item{...}{Additional arguments to be passed to other methods.}
}
\description{
The function \code{mr_plot} has two functionalities. It can generate a visual representation of both \code{MRInput} and \code{MRAll} objects.
}
\details{
The result is dependent on the type of object passed to \code{mr_plot}.
When the object is an \code{MRInput} object, the function uses \code{plotly} syntax to plot the association estimates against eachother. This plot is interactive and the user can hover over the various points to see the name of the associated genetic variant and its association estimates.
When the object is an \code{MRAll} object, the function generates a \code{ggplot} to compare the causal estimates proposed by different methods.
}
\examples{
mr_plot(mr_input(bx = ldlc, bxse = ldlcse, by = chdlodds, byse = chdloddsse),
  line="ivw")
mr_plot(mr_input(bx = ldlc, bxse = ldlcse, by = chdlodds, byse = chdloddsse),
  error=FALSE, line="egger", orientate = TRUE)
mr_plot(mr_allmethods(mr_input(bx = ldlc, bxse = ldlcse,
   by = chdlodds, byse = chdloddsse), method="all", iterations = 1000))
  # iterations is set to 1000 to reduce runtime for the mr_median method,
  # 10000 iterations are recommended in practice
mr_plot(mr_allmethods(mr_input(bx = ldlc, bxse = ldlcse,
   by = chdlodds, byse = chdloddsse), method="ivw"))

}

