% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MVmr_cML}
\alias{MVmr_cML}
\title{MVMRcML method with Data Perturbation}
\usage{
MVmr_cML(
  b_exp,
  b_out,
  se_bx,
  Sig_inv_l,
  n,
  K_vec = as.numeric(c()),
  random_start = 1L,
  min_theta_range = -0.5,
  max_theta_range = 0.5,
  maxit = 100L,
  thres = 1e-04
)
}
\arguments{
\item{b_exp}{A m*L matrix of SNP effects on the exposure variable.}

\item{b_out}{A m*1 matrix of SNP effects on the outcome variable.}

\item{se_bx}{A m*L matrix of standard errors of \code{b_exp}.}

\item{Sig_inv_l}{A list of the inverse of m covariance matrices.}

\item{n}{The smallest sample size of the L+1 GWAS dataset.}

\item{K_vec}{Sets of candidate K's, the constraint parameter representing number of invalid IVs.}

\item{random_start}{Number of random start points, default is 1.}

\item{min_theta_range}{The lower bound of the uniform distribution for each initial value for theta generated from.}

\item{max_theta_range}{The upper bound of the uniform distribution for each initial value for theta generated from.}

\item{maxit}{Maximum number of iterations for each optimization, default is 100.}

\item{thres}{Threshold for convergence criterion.}
}
\value{
A list
\describe{
\item{BIC_theta}{Estimated causal effect from MVMR-cML-BIC}
\item{BIC_invalid}{Invalid IVs selected by MVMR-cML-BIC}
\item{l_vec}{A vector of negative log-likelihood corresponding to each \code{K}.}
\item{K_vec}{A vector of candidate K's}
\item{theta_vec}{A matrix of causal parameter estimates, each column corresponds to a candidate \code{K}.}
\item{Conv_vec}{A vector of successful convergence indicators corresponding to each \code{K}.}
\item{Converge}{Indicator of successful convergence, 0 means success, 1 means failure.}
\item{BIC_vec}{Data perturbation with successful convergence}
\item{Khat}{The length of \code{BIC_invalid}.}
}
}
\description{
This is the internal MVMRcML-BIC function of mr_mvcML.
}
