% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-db_extended.R
\name{checkAdductRule}
\alias{checkAdductRule}
\title{Check for combined adduct rules}
\usage{
checkAdductRule(adduct_rule_scores, adduct_table)
}
\arguments{
\item{adduct_rule_scores}{Scores from countAdductRuleMatches.}

\item{adduct_table}{Adduct table}
}
\value{
Table with TRUE/FALSE for each structure and adduct
}
\description{
Sometimes multiple rules apply - this function checks if they all apply as noted in the rule table.
}
\examples{
 iatom = smiles.to.iatom(c('OC[C@H]1OC(O)[C@H](O)[C@H](O)[C@H]1O'))
 data(adduct_rules)
 data(adducts)
 addScore <- countAdductRuleMatches(iatom, adduct_rules = adduct_rules)
 checkAdductRule(addScore, adduct_table = adducts)
}
\seealso{
\code{\link[data.table]{as.data.table}}
}
