% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaHD.R
\name{MetaHD}
\alias{MetaHD}
\title{A Multivariate Meta-Analysis Model for Metabolomics Data}
\arguments{
\item{Y}{: treatment effect sizes of the outcomes. This should be in the form of a K x N matrix}

\item{Slist}{: K-dimensional list of N x N matrices representing within-study variances and covariances of the treatment effects}

\item{Psi}{: N x N matrix representing between-study variances and covariances of the treatment effects. (optional, if not specified this will be estimated internally by "MetaHD" using "estimateBSvar" and "estimateCorMat" functions in "MetaHD" package}

\item{shrinkCor}{: a logical value indicating whether a shrinkage estimator should be used to estimate between-study correlation matrix. Default is TRUE}

\item{method}{: estimation method: "fixed" for fixed-effects models,"reml" for random-effects models fitted through restricted maximum likelihood}

\item{bscov}{: a character vector defining the structure of the random-effects covariance matrix. Among available covariance structures, the user can select "unstructured" to obtain between-study covariance matrix with diagonal elements (variances) estimated using restricted maximul likelihood and off-diagonal elements (co-variances) reflecting the correlations estimated via shrinkage and "diag" (diagonal) for between-study variances as diagonal elements and zero co-variances}

\item{rigls.maxiter}{: maximum number of iterations of the restricted iterative generalized least square algorithm. Default is set to 1}

\item{impute.na}{: a logical value indicating whether missing values need to be imputed or not. Default is FALSE}

\item{impute.var}{: multiplier for replacing the missing variances in Slist.(a large value, default is 10^4)}
}
\value{
A list of objects containing estimate : a N-dimensional vector of the combined estimates, std.err : a N-dimensional vector of the associated standard errors, pVal : a N-dimensional vector of the p-values, I2.stat : I2 statistic
}
\description{
The MetaHD function performs a multivariate meta-analysis for combining summary estimates obtained from multiple metabolomic studies by using restricted maximum likelihood estimation.
Assuming a meta-analysis is based on N outcomes/metabolites and K studies:
}
