% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CurveFitting.R
\name{areaPermutation}
\alias{areaPermutation}
\title{Calculate Area Ratio (AR) of each feature's time interval for all permutations}
\usage{
areaPermutation(perm)
}
\arguments{
\item{perm}{list has all the permutated models}
}
\value{
returns a list of all permutation area ratio
}
\description{
Fits longitudinal samples from the same group using negative binomial or LOWESS for all permutations
}
\examples{
data(metalonda_test_data)
n.sample = 5 # sample size;
n.timepoints = 10 # time point;
n.perm = 3
n.group= 2 # number of group;
Group = factor(c(rep(0,n.sample*n.timepoints), rep(1,n.sample*n.timepoints)))
Time = rep(rep(1:n.timepoints, times = n.sample), 2)
ID = factor(rep(1:(2*n.sample), each = n.timepoints))
points = seq(1, 10, length.out = 10)
aggretage.df = data.frame(Count = metalonda_test_data[1,], Time = Time, Group = Group, ID = ID)
perm = permutation(aggretage.df, n.perm = 3, method = "nbinomial", points)
areaPermutation(perm)
}
\references{
Ahmed Metwally (ametwa2@uic.edu)
}

