% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryStatistics.R
\name{MeanSiteFChange_cherry}
\alias{MeanSiteFChange_cherry}
\title{Compute the Mean Site Frequency of Methylation Changes per Cherry}
\usage{
MeanSiteFChange_cherry(
  data,
  categorized_data = FALSE,
  tree,
  index_islands,
  index_nonislands
)
}
\arguments{
\item{data}{A list containing methylation states at tree tips for each genomic structure (e.g., island/non-island).
The data should be structured as \code{data[[tip]][[structure]]}, where each structure has the same number of sites across tips.
The input data must be prefiltered to ensure CpG sites are represented consistently across different tips.
Each element contains the methylation states at the sites in a given tip and structure
represented as 0, 0.5 or 1 (for unmethylated, partially-methylated and methylated).
If methylation states are not represented as 0, 0.5, 1 they are categorized
as 0 when value equal or under 0.2
0.5 when value between 0.2 and 0.8
and 1 when value over 0.8.
For customized categorization thresholds use \code{categorize_siteMethSt}}

\item{categorized_data}{Logical defaulted to FALSE.
TRUE to skip redundant categorization when methylation states are represented as 0, 0.5, and 1.}

\item{tree}{A phylogenetic tree in Newick format or a \code{phylo} object from the \code{ape} package.
The function ensures the tree has a valid structure and at least two tips.}

\item{index_islands}{A numeric vector specifying the indices of genomic structures corresponding to islands.}

\item{index_nonislands}{A numeric vector specifying the indices of genomic structures corresponding to non-islands.}
}
\value{
A data frame with one row per cherry, containing the following columns:
\describe{
\item{tip_names}{A character string representing the names of the two tips in the cherry, concatenated with a hyphen.}
\item{tip_indices}{A character string representing the indices of the two tips in the cherry, concatenated with a hyphen.}
\item{dist}{A numeric value representing the sum of the branch distances between the cherry tips.}
\item{nonisland_meanFChange}{A numeric value representing the weighted mean frequency of methylation changes in non-island structures.}
\item{island_meanFChange}{A numeric value representing the weighted mean frequency of methylation changes in island structures.}
}
}
\description{
This function calculates the weighted mean frequency of methylation changes at island and non-island genomic structures
for each cherry in a phylogenetic tree. A cherry is a pair of leaf nodes (also called tips or terminal nodes)
in a phylogenetic tree that share a direct common ancestor.
}
\details{
The function first validates the tree and the input data structure. It then computes the
per-cherry frequency of sites with different methylation states using \code{get_siteFChange_cherry}.
The indices provided for islands and non-islands are checked for validity using \code{validate_structureIndices}.
Finally, the function calculates the weighted mean site frequency of methylation changes for each cherry,
separately for islands and non-islands.
}
\examples{
# Example data setup
data <- list(
list(rep(1,10), rep(0,5), rep(1,8)), # Tip a
list(rep(1,10), rep(0.5,5), rep(0,8)), # Tip b
list(rep(1,10), rep(0.5,5), rep(0,8)), # Tip c
list(c(rep(0,5), rep(0.5, 5)), c(0, 0, 1, 1, 1), c(0.5, 1, rep(0, 6)))) # Tip d

tree <- "((a:1.5,b:1.5):2,(c:2,d:2):1.5);"

index_islands <- c(1,3)
index_nonislands <- c(2)

MeanSiteFChange_cherry(data = data, 
                       categorized_data = TRUE, 
                       tree = tree, 
                       index_islands = index_islands,
                       index_nonislands = index_nonislands)

}
