% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini_coefficient.R
\name{gini_coefficient}
\alias{gini_coefficient}
\title{Gini Coefficient}
\usage{
gini_coefficient(actual, predicted, w = NULL, ...)
}
\arguments{
\item{actual}{Observed values (0 or 1).}

\item{predicted}{Predicted values of any value (not necessarly between 0 and 1).}

\item{w}{Optional case weights.}

\item{...}{Further arguments passed to \code{AUC}.}
}
\value{
A numeric vector of length one.
}
\description{
Calculates weighted Gini coefficient, obtained as 2 * AUC - 1. Up to ties in \code{predicted} equivalent to Somer's D. The larger the Gini coefficient, the better.
}
\examples{
gini_coefficient(c(0, 0, 1, 1), 2 * c(0.1, 0.1, 0.9, 0.8))
gini_coefficient(c(0, 0, 1, 1), c(0.1, 0.6, 0.9, 0.5))
gini_coefficient(c(0, 0, 1, 1), c(0.1, 0.6, 0.9, 0.5), w = 1:4)
}
\seealso{
\code{\link{AUC}}.
}
