% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_squared_poisson.R
\name{r_squared_poisson}
\alias{r_squared_poisson}
\title{Pseudo R-Squared regarding Poisson deviance}
\usage{
r_squared_poisson(actual, predicted, w = NULL, reference_mean = NULL, ...)
}
\arguments{
\item{actual}{Observed values.}

\item{predicted}{Predicted values.}

\item{w}{Optional case weights.}

\item{reference_mean}{An optional reference mean used to derive the null deviance. Recommended in out-of-sample applications.}

\item{...}{Further arguments passed to \code{r_squared}.}
}
\value{
A numeric vector of length one.
}
\description{
Wrapper to \code{r_squared} with \code{deviance_function = deviance_poisson}.
}
\details{
The deviance gain is calculated regarding the null model derived from the actual values. While fine for in-sample considerations, this is only an approximation for out-of-sample considerations. There, it is recommended to calculate null deviance regarding the in-sample (weighted) mean. This value can be passed by the argument \code{reference_mean}.
}
\examples{
r_squared(0:2, c(0.1, 1, 2), w = rep(1, 3),
          deviance_function = deviance_poisson)
r_squared_poisson(0:2, c(0.1, 1, 2), w = rep(1, 3))
}
\seealso{
\code{\link{r_squared}}.
}
