% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mexico_gdp.R
\name{get_mexico_gdp}
\alias{get_mexico_gdp}
\title{Get Mexico's GDP (Current US$) from World Bank}
\usage{
get_mexico_gdp()
}
\value{
A tibble with the following columns:
\describe{
  \item{indicator}{Indicator name (e.g., "GDP (current US$)")}
  \item{country}{Country name ("Mexico")}
  \item{year}{Year of the data (integer)}
  \item{value}{GDP value in numeric form}
  \item{value_label}{Formatted GDP value (e.g., "1,466,464,899,304")}
}
}
\description{
Retrieves Mexico's Gross Domestic Product (GDP) in current US dollars
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is `NY.GDP.MKTP.CD`.
}
\details{
The function sends a GET request to the World Bank API.
If the API request fails or returns an error status code, the function returns `NULL` with an informative message.
}
\note{
Requires internet connection. The data is retrieved in real time from the World Bank API.
}
\examples{
if (interactive()) {
  get_mexico_gdp()
}

}
\seealso{
\link[httr]{GET}, \link[jsonlite]{fromJSON}, \link[dplyr]{as_tibble}, \link[scales]{comma}
}
