% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{plot_corply}
\alias{plot_corply}
\title{plot_corply}
\usage{
plot_corply(
  res,
  main = NULL,
  zlim = NULL,
  reorder.x = FALSE,
  reorder.y = reorder.x,
  resort_on_p = FALSE,
  abs = FALSE,
  cor.abs = FALSE,
  reorder_dend = FALSE
)
}
\arguments{
\item{res}{associations obtained with cor.assoc}

\item{main}{title of the plot}

\item{zlim}{max association to plot}

\item{reorder.x}{logical indicating if the function should reorder the x axis based on clustering}

\item{reorder.y}{logical indicating if the function should reorder the y axis based on clustering}

\item{resort_on_p}{logical indicating if the function should reorder x and y axis based on the pvalues of the associations}

\item{abs}{logical indicating if the function should  reorder based the absolute values}

\item{cor.abs}{logical indicating if the function should reorder the plot base on the absolute values}

\item{reorder_dend}{Tlogical indicating if the function should reorder the plot based on dendrogram}
}
\value{
heatmap with the results of cor.assoc
}
\description{
Function creating plottig the correlation between 2 datasets, dat1 x dat2 on basis of (partial) correlations
}
\examples{
library(stats)

#load the dataset
m <- as.matrix(synthetic_metabolic_dataset)

#Compute the pearson correlation of all the variables in the data.frame metabolic_measures
cors<-cor_assoc(m, m, MiMIR::metabolites_subsets$MET63,MiMIR::metabolites_subsets$MET63)
#Plot the correlations
plot_corply(cors, main="Correlations metabolites")

}
\seealso{
cor_assoc
}
