% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ClusterModelNames.R
\name{clusterPoissonNames}
\alias{clusterPoissonNames}
\alias{clusterValidPoissonNames}
\title{Build a vector of Poisson model names.}
\usage{
clusterPoissonNames(prop = "all", mean = "all")

clusterValidPoissonNames(names)
}
\arguments{
\item{prop}{A character string equal to "equal", "free" or "all". Default is "all".}

\item{mean}{A character string equal to "equal", "free", "proportional or "all". Default is "all".}

\item{names}{a vector of character}
}
\value{
A vector of character with the model names.
}
\description{
In a poisson model, we can build 4 models:
\enumerate{
 \item {The proportions can be equal or free.}
 \item {The means can be equal, free or proportional for all the variables.}
}

check if a vector of Poisson model name is correct.
}
\details{
The model names are summarized in the following array:
\tabular{lll}{
 Model Name      \tab Proportions \tab Mean between variables \cr
 poisson_p_ljk   \tab Equal       \tab Free                   \cr
 poisson_p_lk    \tab Equal       \tab Equal                  \cr
 poisson_p_ljlk  \tab Equal       \tab Proportional           \cr
 poisson_pk_ljk  \tab Free        \tab Free                   \cr
 poisson_pk_lk   \tab Free        \tab Equal                  \cr
 poisson_pk_ljlk \tab Free        \tab Proportional
}
}
\examples{
clusterPoissonNames()
clusterPoissonNames("all", "proportional") # same as c( "poisson_pk_ljlk", "poisson_p_ljlk")
}
\keyword{internal}

