% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tone}
\alias{tone}
\title{Tone perception data}
\format{
A data frame containing 150 observations and the following 2 variables.
\describe{
\item{stretchratio:}{ electronically generated overtones added to a pure fundamental tone.}
\item{tuned:}{ ratio of the adjusted tone to the fundamental tone.}
}
}
\source{
Original source:

Cohen, E. (1980). Inharmonic tone perception. Unpublished Ph. D. Dissertation, Stanford University.

R source:

Hennig C (2023). fpc: Flexible Procedures for Clustering. R package version 2.2-10,
\url{https://CRAN.R-project.org/package=fpc}

Benaglia, T., Chauveau, D., Hunter, D. R., and Young, D. S. (2010).
mixtools: an R package for analyzing mixture models. Journal of statistical software, 32, 1-29.
}
\usage{
tone
}
\description{
The data originates from an experiment of Cohen (1980) and has been analyzed in de Veaux (1989) and
Viele and Tong (2002). In this experiment, a pure fundamental tone was played to a trained musician.
To create different auditory conditions, electronically generated overtones were introduced, which were
determined by a stretching ratio. When \code{stretchratio = 2.0}, it aligns with the harmonic pattern
usually heard in traditional definite pitched instruments. The musician was asked to tune an adjustable
tone to the octave above the fundamental tone. The variable \code{tuned} gives the ratio of the adjusted
tone to the fundamental tone. For example, \code{tuned = 2.0},  would be the correct tuning for all
\code{stretchratio} values. This dataset comprises data collected from 150 trials conducted with
the same musician. In the original study, data were gathered from an additional four musicians as well.
The dataset and the description have been sourced from the \code{tonedata} of the `fpc' package.
}
\references{
De Veaux, R. D. (1989). Mixtures of linear regressions. Computational Statistics & Data Analysis,
8(3), 227-245.

Viele, K. and Tong, B. (2002). Modeling with mixtures of linear regressions. Statistics and Computing, 12, 315-330.
}
\keyword{datasets}
