% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{hide_values}
\alias{hide_values}
\title{Missing Values Generation}
\usage{
hide_values(X, prop_cases = 0.1, n_cases = NULL)
}
\arguments{
\item{X}{An \eqn{n} by \eqn{d} matrix or data frame where \eqn{n} is the number of
observations and \eqn{d} is the number of columns or variables. \code{X} must
have at least 2 rows and 2 columns.}

\item{prop_cases}{(optional) Proportion of observations that contain some missing values.
\code{prop_cases} must be a number in \eqn{(0, 1)}. \code{prop_cases = 0.1}
by default, but will be ignored if \code{n_cases} is specified.}

\item{n_cases}{(optional) Number of observations that contain some missing values.
\code{n_cases} must be an integer ranging from 1 to \code{nrow(X) - 1}.}
}
\value{
The orginal \eqn{n} by \eqn{d} matrix or data frame with missing values.
}
\description{
A convenient function that randomly introduces missing values to an at-least-bivariate
data set. The user can specify either the proportion of observations that contain some
missing values or the exact number of observations that contain some missing values.
Note that the function does not guarantee that underlying missing-data
mechanism to be missing at random (MAR).
}
\details{
If subject to missingness, an observation can have at least 1 and at
  most \code{ncol(X) - 1} missing values. Depending on the data
  set, it is not guaranteed that the resulting matrix will have the number of
  rows with missing values matches the specified proportion.
}
\examples{
set.seed(1234)

hide_values(iris[1:4])
hide_values(iris[1:4], prop_cases = 0.5)
hide_values(iris[1:4], n_cases = 80)

}
