% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.haplo.R
\name{get.haplo}
\alias{get.haplo}
\title{Derive haplotypes of selected individuals}
\usage{
get.haplo(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  chromosomen = "all",
  export.alleles = FALSE,
  non.genotyped.as.missing = FALSE,
  use.id = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{chromosomen}{Beschraenkung der Haplotypen auf bestimmte Chromosomen (default: 1)}

\item{export.alleles}{If TRUE export underlying alleles instead of just 012}

\item{non.genotyped.as.missing}{Set to TRUE to replace non-genotyped markers with NA}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names (default: FALSE)}
}
\value{
Haplotype data for in gen/database/cohorts selected individuals
}
\description{
Function to devide haplotypes of selected individuals
}
\examples{
data(ex_pop)
haplo <- get.haplo(ex_pop, gen=2)
}
