% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Functions.R
\name{MoE_plotLogLik}
\alias{MoE_plotLogLik}
\title{Plot the Log-Likelihood of a MoEClust Mixture Model}
\usage{
MoE_plotLogLik(res, type = "l", xlab = "Iteration",
  ylab = "Log-Likelihood", xaxt = "n", ...)
}
\arguments{
\item{res}{An object of class \code{"MoEClust"} generated by \code{\link{MoE_clust}}, or an object of class \code{"MoECompare"} generated by \code{\link{MoE_compare}}.}

\item{type, xlab, ylab, xaxt}{These graphical parameters retain their usual definitions from \code{\link[graphics]{plot}}.}

\item{...}{Catches unused arguments, or additional arguments to be passed to \code{\link[graphics]{plot}}.}
}
\value{
A plot of the log-likelihood versus the EM iterations.
}
\description{
Plots the log-likelihood at every iteration of the EM algorithm used to fit a MoEClust mixture model.
}
\note{
\code{\link{plot.MoEClust}} is a wrapper to \code{\link{MoE_plotLogLik}} which accepts the default arguments, and also produces other types of plots.
}
\examples{
data(ais)
res <- MoE_clust(ais[,3:7], gating= ~ BMI, expert= ~ sex,
                 G=2, modelNames="EVE", network.data=ais)
MoE_plotLogLik(res)
}
\seealso{
\code{\link{MoE_clust}}, \code{\link{plot.MoEClust}},
}
\author{
Keefe Murphy - <\email{keefe.murphy@ucd.ie}>
}
\keyword{plotting}
