% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint.R
\name{evalJointFunction}
\alias{evalJointFunction}
\title{Evaluate a Joint Function}
\usage{
evalJointFunction(P, values)
}
\arguments{
\item{P}{A \code{"jointmotbf"} object.}

\item{values}{A list with the name of the variables equal to the values to be evaluate.}
}
\value{
If all the variables in the equation are evaluated then the return is a \code{"numeric"} value,
if not an \code{"motbf"} object or a \code{"jointmotbf"} object is returned.
}
\description{
Evaluates a \code{"jointmotbf"} object at a specific point.
}
\examples{
#' ## 1. EXAMPLE
## Dataset with 2 variables
X <- data.frame(rnorm(100), rexp(100))

## Joint function
dim <- c(3,3) # dim <- c(5,4)
param <- parametersJointMoTBF(X, dimensions = dim)
P <- jointMoTBF(param)
P

## Evaluation
nVariables(P)
val <- list(x = -1.5, y = 3)
evalJointFunction(P, values = val)
val <- list(x = -1.5)
evalJointFunction(P, values = val)
val <- list(y = 3)
evalJointFunction(P, values = val)

##############################################################################
## MORE EXAMPLES #############################################################
############################################################################## 
\donttest{
## Dataset with 3 variables
X <- data.frame(rnorm(100), rexp(100), rnorm(100, 1))

## Joint function
dim <- c(2,1,3)
param <- parametersJointMoTBF(X, dimensions = dim)
P <- jointMoTBF(param)
P

## Evaluation
nVariables(P)
val <- list(x = 0.8, y = -2.1, z = 1.2)
evalJointFunction(P, values = val)
val <- list(x = 0.8, z = 1.2)
evalJointFunction(P, values = val)
val <- list(y = -2.1)
evalJointFunction(P, values = val)
val <- list(y = -2.1)
evalJointFunction(P, values = val)
}
}
