% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-handling.R
\name{select}
\alias{select}
\title{Selects (ala dplyr) on Momocs objects}
\usage{
select(.data, ...)
}
\arguments{
\item{.data}{a \code{Coo}, \code{Coe}, \code{PCA} object}

\item{...}{comma separated list of unquoted expressions}
}
\value{
a Momocs object of the same class.
}
\description{
Select variables by name, from the \code{$fac}. See examples and \code{?dplyr::select}.
}
\details{
dplyr verbs are maintained.
}
\examples{
data(olea)
olea
select(olea, var, view) # drops domes and ind
select(olea, variety=var, domesticated_status=domes, view)
# combine with filter with magrittr pipes
# only dorsal views, and 'var' and 'domes' columns
filter(olea, view=="VD") \%>\% select(var, domes)
head(olea$fac)
# select some columns
select(olea, domes, view)
# remove some columns
select(olea, -ind)
# rename on the fly and select some columns
# you can use rename instead
select(olea, foo=domes)

}
\seealso{
Other handling functions: \code{\link{arrange}},
  \code{\link{at_least}}, \code{\link{chop}},
  \code{\link{combine}}, \code{\link{dissolve}},
  \code{\link{filter}}, \code{\link{mutate}},
  \code{\link{rename}}, \code{\link{rm_uncomplete}},
  \code{\link{rw_fac}}, \code{\link{sample_frac}},
  \code{\link{sample_n}}, \code{\link{slice}},
  \code{\link{subset.Coo}}
}
