\name{typprob}
\alias{typprob}
\alias{typprobClass}
\title{calculate typicality probabilities}
\usage{
typprob(x, data, small = FALSE, method = c("chisquare", "wilson"),
  center = NULL, cova = NULL)

typprobClass(x, data, groups, small = FALSE, method = c("chisquare",
  "wilson"), outlier = 0.01, sep = FALSE)
}
\arguments{
  \item{x}{vector or matrix of data the probability is to
  be calculated.}

  \item{data}{Reference data set.}

  \item{groups}{vector containing grouping information.}

  \item{small}{adjustion of Mahalanobis D^2 for small
  sample sizes as suggested by Wilson (1981), only takes
  effect when method="wilson".}

  \item{method}{select method for probability estimation.
  Available options are "chisquare" (or any abbreviation)
  or "wilson". "chisquare" exploits simply the chisquare
  distribution of the mahalanobisdistance, while "wilson"
  uses the methods suggested by Wilson(1981). Results will
  be similar in general.}

  \item{outlier}{probability threshold below which a
  specimen will not be assigned to any group-}

  \item{sep}{logical: if TRUE, probability will be
  calculated from the pooled within group covariance
  matrix.}

  \item{center}{vector: specify custom vector to calculate
  distance to. If not defined, group mean will be used.}

  \item{cova}{covariance matrix to calculate
  mahalanobis-distance: specify custom covariance matrix to
  calculate distance.}
}
\value{
typprob: returns a vector of probabilities.

typprobClass: \item{probs }{matrix of probabilities for
each group} \item{groupaffin }{vector of groups each
specimen has been assigned to. Outliers are classified
"none"}
}
\description{
calculate typicality probabilities
}
\details{
get the probability for an observation belonging to a given
multivariate nromal distribution
}
\examples{
library(shapes)
data <- procSym(gorf.dat)$PCscores[,1:3]
probas <- typprob(data,data,small=TRUE)### get probability for each specimen

### now we check how this behaves compared to the mahalanobis distance
maha <- mahalanobis(data,apply(data,2,mean),cov(data))
plot(probas,maha,xlab="Probability",ylab="Mahalanobis D^2")

data2 <- procSym(abind(gorf.dat,gorm.dat))$PCscores[,1:3]
fac <- as.factor(c(rep("female",dim(gorf.dat)[3]),rep("male",dim(gorm.dat)[3])))
typClass <- typprobClass(data2,data2,fac,method="w",small=TRUE)
## only 59 specimen is rather small.
typClass2 <- typprobClass(data2,data2,fac,method="c")## use default settings

### check results for first method:
ct <- table(fac,typClass$groupaffin)
ct #view classification table
### get percentage of correct classification
prop.table(ct, 1)

### check results for second method:
ct1 <- table(fac,typClass2$groupaffin)
ct1 #view classification table ### one specimen has been tagged an outlier.
### get percentage of correct callification
prop.table(ct1, 1)
}
\author{
Stefan Schlager
}
\references{
Albrecht G. 1992. Assessing the affinities of fossils using
canonical variates and generalized distances Human
Evolution 7:49-69.

Wilson S. 1981. On comparing fossil specimens with
population samples Journal of Human Evolution 10:207 - 214.
}
\keyword{~kwd1}
\keyword{~kwd2}

