% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtualMeshScan.r
\name{virtualMeshScan}
\alias{virtualMeshScan}
\title{remove all parts of a triangular mesh, not visible from a set of viewpoints}
\usage{
virtualMeshScan(x, viewpoints, offset = 0.001, cores = 1)
}
\arguments{
\item{x}{triangular mesh of class 'mesh3d'}

\item{viewpoints}{vector or k x 3  matrix containing a set of viewpoints}

\item{offset}{value to generate an offset at the meshes surface (see notes)}

\item{cores}{integer: number of cores to use (not working on windows)}
}
\value{
returns a list containing subsets of the original mesh
\item{visible}{the parts visible from at least one of the viewpoints}
\item{invisible}{the parts not visible from the viewpoints}
}
\description{
remove all parts of a triangular mesh, not visible from a set of viewpoints
}
\note{
The function tries to filter out all vertices where the line connecting each vertex with the viewpoints intersects with the mesh itself. As, technically speaking this always occurs at a distance of value=0, a mesh with a tiny offset is generated to avoid these false hits.
}
\examples{
SCP1 <- file2mesh(system.file("extdata","SCP1.ply",package="Morpho"))
viewpoints <- read.fcsv(system.file("extdata","SCP1_Endo.fcsv",package="Morpho"))
## Create a quick endocast
quickEndo <- virtualMeshScan(SCP1,viewpoints)
\dontrun{
rgl::shade3d(quickEndo$visible,col="orange")
rgl::shade3d(SCP1,col="white",alpha=0.5)
}
}
