% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.Mposterior}
\alias{plot.Mposterior}
\title{Plot an object of class Mposterior.}
\usage{
\method{plot}{Mposterior}(x, ...)
}
\arguments{
\item{x}{object of class Mposterior or output of \code{\link{findWeiszfeldMedian}}}

\item{...}{extra arguments are ignored currently}
}
\description{
Plot of Mposterior class object; ... are ignored.
}
\examples{
set.seed(12345)
## list that contains subset posterior samples from 2-dim Gaussian density
subAtomList <- vector("list", 5)
subAtomList[[1]] <- cbind(rnorm(100, mean = 1),  rnorm(100, mean = 1))
subAtomList[[2]] <- cbind(rnorm(100, mean = -1),  rnorm(100, mean= -1))
subAtomList[[3]] <- cbind(rnorm(100, mean = -1),  rnorm(100, mean = 1))
subAtomList[[4]] <- cbind(rnorm(100, mean = 1),  rnorm(100, mean = -1))
subAtomList[[5]] <- cbind(rnorm(100, mean = 2),  rnorm(100, mean = 2))
library(Mposterior)
medPosterior <- findWeiszfeldMedian(subAtomList, sigma = 0.1, maxit = 100, tol = 1e-10)
plot(medPosterior)
}
\author{
Sanvesh Srivastava \email{sanvesh@gmail.com}
}

