% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult_Set_Functions.R
\name{mult_inv_large}
\alias{mult_inv_large}
\title{Inverse each 2D slice of an array (M) with arbitrary dimensions support}
\usage{
mult_inv_large(M)
}
\arguments{
\item{M}{multi-dimension array}
}
\value{
n_D array (m x m x [p x q x  ...]), with same size as M
}
\description{
Inverse each 2D slice of an array (M) with arbitrary dimensions support
}
\details{
Inverse every 2D slice (the first two dimensions of M) for multi-dimension array M.
  M[,,p,q,...] * X[,,p,q,...] <- repmat(diag(m),[1,1,p,q,...])
}
\references{
This function is based on the "mult_inv_large" function by Le and Singleton (2018).\cr
 "A Small Package of Matlab Routines for the Estimation of Some Term Structure Models." \cr
 (Euro Area Business Cycle Network Training School - Term Structure Modelling).
Available at: https://cepr.org/40029
}
\keyword{internal}
